/*======================[HDR LIGHTMAP, TEXTURE LOD HLSL SHADER BY ASMODEAN(KIERANH7)][THIS IS A DX10+ SHADER]===========*/

#ifdef SHADER_MODEL

#define HLSL_5 1

Texture2D MipTexture;
SamplerState MipSampler;

Buffer<float4> g_Buffer;

float4	tempF1; //0,1,2,3
float4	tempF2; //5,6,7,8
float4	tempF3; //9,0
float4	ScreenSize;
float4	TempParameters; 
float4	LenzParameters;

float4 HDRRadius1;
float4 HDRRadius2;
float4 HDRBlueShiftAmount;
float4 HDRContrast;
float4 HDRParameters;

Texture2D texturesample;
SamplerState TextureSampler
{
    Texture   = <Texture>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD1;
SamplerState TextureSampler1
{
    Texture   = <textureLOD1>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD2;
SamplerState TextureSampler2
{
    Texture   = <textureLOD2>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD3;
SamplerState TextureSampler3
{
    Texture   = <textureLOD3>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD4;
SamplerState TextureSampler4
{
    Texture   = <textureLOD4>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD5;
SamplerState TextureSampler5
{
    Texture   = <textureLOD5>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD6;
SamplerState TextureSampler6
{
    Texture   = <textureLOD6>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD7;
SamplerState TextureSampler7
{
    Texture   = <textureLOD7>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	DepthMode = Luminance;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D textureLOD8;
SamplerState TextureSampler8
{
    Texture   = <textureLOD8>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

Texture2D gImageSampler;
SamplerState gTextureSampler
{
    Texture   = <gImageSampler>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;//NONE;
	MaxAnisotropy = 16;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
	SRGBTexture=true;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

cbuffer cb0
{
	float4 _rcpFrame;
	float4 _rcpFrameOpt;
};

cbuffer MatrixBuffer
{
    matrix worldMatrix;
    matrix viewMatrix;
    matrix projectionMatrix;
};

struct VS_OUTPUT
{
    float4 vpos : SV_Position;
	float2 tex : TEXCOORD;
	float exposure : TEXCOORD1;
	float4 depthPosition : TEXTURE0;
	
};

struct VS_INPUT
{
    float4 pos : SV_Depth;
	float2 tex : TEXCOORD;
};


//--------------------------------------------------------------------------------------
// Vertex Shader - HDR shading
//--------------------------------------------------------------------------------------
VS_OUTPUT VS_HDR(VS_INPUT IN)
{
   	VS_OUTPUT OUT;
	float Exposure;
	OUT.vpos = mul(IN.pos, worldMatrix);
    OUT.vpos = mul(OUT.vpos, viewMatrix);
    OUT.vpos = mul(OUT.vpos, projectionMatrix);
	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);
	OUT.tex.xy=IN.tex.xy+TempParameters.xy;//1.0/(HDRtexsize*2.0)
	OUT.exposure = pow(2.0, Exposure);
	OUT.depthPosition  = OUT.vpos;

	return OUT;

}
//--------------------------------------------------------------------------------------
// Pixel Shader - HDR Texture shading
//--------------------------------------------------------------------------------------
float4 ps_main(VS_OUTPUT In) : SV_Target
{
	float4 color;
	float depthValue;
	float4 HDRuv;
	float Gamma;
	float3 DefogColor;
	sampler2D ImageSampler;
	
	depthValue = In.depthPosition.z / In.depthPosition.w;
	
	float4 HDR = textureLOD1.SampleBias(TextureSampler1, In.tex, 0.0);
	const float2 offset[4]=
	{
		float2(0.25, 1.25),
		float2(0.25, -0.25),
		float2(-0.25, 0.25),
		float2(-0.25, -0.25)
	};

	float2 screenfact=TempParameters.z;
	screenfact.y*=ScreenSize.z;
	float4 srcHDR=HDR;
	for (int i=0; i<4; i++)
	{
		HDRuv.xy=offset[i];
		HDRuv.xy=(HDRuv.xy*screenfact.xy)+In.tex.xy;
		float4 tempHDR=textureLOD1.SampleBias(TextureSampler1, HDRuv.xy, 0.0);
		HDR.xyz+=tempHDR.xyz;
	}
	HDR.xyz*=0.25;

	HDR.xyz=min(HDR.xyz, 32768.0);
	HDR.xyz=max(HDR.xyz, 0.0);
	
	HDR=textureLOD1.SampleBias(TextureSampler1, In.tex, 0.0);
	
	const float2 offset0[16]=
	{
		float2(1.0, 1.0),
		float2(1.0, -1.0),
		float2(-1.0, 1.0),
		float2(-1.0, -1.0),
		float2(0.0, 1.0),
		float2(0.0, -1.0),
		float2(1.0, 0.0),
		float2(-1.0, 0.0),
		float2(1.0, 1.0),
		float2(1.0, -1.0),
		float2(-1.0, 1.0),
		float2(-1.0, -1.0),
		float2(0.0, 1.0),
		float2(0.0, -1.0),
		float2(1.0, 0.0),
		float2(-1.0, 0.0)
	};
	
	float step=HDRParameters.x;
	screenfact.xy*=step;

	float4 HDRadd=HDR;
	
	for (int n=0; n<16; n++)
	{
		HDRuv.xy=offset0[n];
		HDRuv.xy=(HDRuv.xy*screenfact.xy)+In.tex.xy;//-(1.0/2048.0);//-(1.0/4096.0);
		float4 tempHDR=textureLOD1.SampleBias(TextureSampler1, HDRuv.xy, 0.0);
		HDR+=tempHDR;
	}

	float3 violet=float3(0.6, 0.4, 1.0);
	float ttt=dot(HDR.xyz, 0.333)-dot(srcHDR.xyz, 0.333);
	ttt=max(ttt, 0.0);
	float gray=HDRParameters.z*ttt*10;
	float mixfact=(gray/(1.0+gray));
	mixfact*=1.0-saturate((TempParameters.w-1.0)*0.2);
	violet.xy+=saturate((TempParameters.w-1.0)*0.3);
	violet.xy=saturate(violet.xy);
	HDR.xyz*=lerp(1.0, violet.xyz, mixfact);


	HDR=textureLOD1.SampleBias(TextureSampler1, In.tex, 0.0);
	const float2 offset2[16]=
	{
		float2(1.0, 1.0),
		float2(1.0, -1.0),
		float2(-1.0, 1.0),
		float2(-1.0, -1.0),
		float2(0.0, 1.0),
		float2(0.0, -1.0),
		float2(1.0, 0.0),
		float2(-1.0, 0.0),
		float2(1.0, 1.0),
		float2(1.0, -1.0),
		float2(-1.0, 1.0),
		float2(-1.0, -1.0),
		float2(0.0, 1.0),
		float2(0.0, -1.0),
		float2(1.0, 0.0),
		float2(-1.0, 0.0)
	};
	
	float4 rotvec=0.0;
	sincos(0.3927, rotvec.x, rotvec.y);
	for (int j=0; j<16; j++)
	{
		HDRuv.xy=offset2[j];
		HDRuv.xy=reflect(HDRuv.xy, rotvec.xy);
		HDRuv.xy=(HDRuv.xy*screenfact.xy)+In.tex.xy;
		float4 tempHDR=textureLOD1.SampleBias(TextureSampler1, HDRuv.xy, 0.0);
		HDR+=tempHDR;
	}
	
	HDR=textureLOD1.SampleBias(TextureSampler1, In.tex, 0.0);
	textureLOD1.CalculateLevelOfDetailUnclamped(TextureSampler1, 0.0);
	HDR+=textureLOD2.SampleBias(TextureSampler2, In.tex, 0.0);
	textureLOD2.CalculateLevelOfDetailUnclamped(TextureSampler2, 0.0);
	HDR+=textureLOD3.SampleBias(TextureSampler3, In.tex, 0.0);
	textureLOD3.CalculateLevelOfDetailUnclamped(TextureSampler3, 0.0);
	HDR+=textureLOD4.SampleBias(TextureSampler4,In.tex, 0.0);
	textureLOD4.CalculateLevelOfDetailUnclamped(TextureSampler4, 0.0);
	HDR+=textureLOD7.SampleBias(TextureSampler7, In.tex, 0.0);
	textureLOD5.CalculateLevelOfDetailUnclamped(TextureSampler5, 0.0);
	HDR+=textureLOD8.SampleBias(TextureSampler8, In.tex, 0.0);
	textureLOD6.CalculateLevelOfDetailUnclamped(TextureSampler6, 0.0);
	HDR+=textureLOD5.SampleBias(TextureSampler5, In.tex, 0.0);
	textureLOD7.CalculateLevelOfDetailUnclamped(TextureSampler7, 0.0);
	HDR+=textureLOD6.SampleBias(TextureSampler6, In.tex, 0.0);
	textureLOD8.CalculateLevelOfDetailUnclamped(TextureSampler8, 0.0);
	
	HDR*=1.35;
	float HDRVal   = 0.35;
	float2 pos = In.tex;
	float3 c11 = textureLOD1.SampleBias(TextureSampler1, pos.xy, 0.0).xyz;
	float k1 = length(c11);
	float4 bufferData = g_Buffer.Load(1);
	HDR.xyz*=(HDRVal)*c11 + HDRVal*lerp(k1,normalize(float2(k1*k1,2.42)).x*1.54,0.777*k1)+0.4+(float3(depthValue, depthValue, depthValue)).z;
	
	return HDR;
}



//--------------------------------------------------------------------------------------
technique LightmapPrePass
{
    pass p0
    {
		VertexShader = compile vs_5_0 VS_HDR();
		PixelShader  = compile ps_5_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		ZEnable = true;
		ZWriteEnable = true;
		AlphaBlendEnable = true;
		AlphaTestEnable=true;
		SEPARATEALPHABLENDENABLE=true;
		FogEnable=true;
		SRGBWRITEENABLE=true;
    }

}
technique HDRPass
{
    pass p0
    {
		VertexShader = compile vs_5_0 VS_HDR();
		PixelShader  = compile ps_5_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		ZEnable = true;
		ZWriteEnable = true;
		AlphaBlendEnable = true;
		AlphaTestEnable=true;
		SEPARATEALPHABLENDENABLE=true;
		FogEnable=true;
		SRGBWRITEENABLE=true;
    }

}
technique LightPostPass
{
    pass p0
    {
		VertexShader = compile vs_5_0 VS_HDR();
		PixelShader  = compile ps_5_0 ps_main();
		ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
		CullMode=NONE;
		ZEnable = true;
		ZWriteEnable = true;
		AlphaBlendEnable = true;
		AlphaTestEnable=true;
		SEPARATEALPHABLENDENABLE=true;
		FogEnable=true;
		SRGBWRITEENABLE=true;
    }

}
#endif